/*
 * Decompiled with CFR 0.152.
 */
package fr.minecraftforgefrance.common;

import argo.format.JsonFormatter;
import argo.format.PrettyJsonFormatter;
import argo.jdom.JdomParser;
import argo.jdom.JsonField;
import argo.jdom.JsonNode;
import argo.jdom.JsonNodeFactories;
import argo.jdom.JsonRootNode;
import argo.jdom.JsonStringNode;
import argo.saj.InvalidSyntaxException;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import fr.minecraftforgefrance.common.DownloadUtils;
import fr.minecraftforgefrance.common.EnumOS;
import fr.minecraftforgefrance.common.FileChecker;
import fr.minecraftforgefrance.common.FileEntry;
import fr.minecraftforgefrance.common.IInstallRunner;
import fr.minecraftforgefrance.common.LibEntry;
import fr.minecraftforgefrance.common.Localization;
import fr.minecraftforgefrance.common.RemoteInfoReader;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class ProcessInstall {
    private JFrame frame;
    private JProgressBar fileProgressBar;
    private JProgressBar fullProgressBar;
    private JPanel panel;
    private JLabel downloadSpeedLabel;
    private JLabel currentDownload;
    private File mcDir = EnumOS.getMinecraftDefaultDir();
    private File modPackDir = new File(new File(this.mcDir, "modpacks"), RemoteInfoReader.instance().getModPackName());
    private final FileChecker fileChecker;
    private final IInstallRunner runner;
    private final boolean update;
    private static final JsonFormatter JSON_FORMATTER = new PrettyJsonFormatter();

    public ProcessInstall(FileChecker file, IInstallRunner runner, boolean update) {
        this.fileChecker = file;
        this.runner = runner;
        this.update = update;
        this.frame = new JFrame();
        this.frame.setTitle(Localization.LANG.getTranslation("proc.downloadingmods"));
        this.frame.setDefaultCloseOperation(2);
        this.frame.setResizable(false);
        this.frame.setSize(500, 100);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int x = dim.width / 2 - this.frame.getSize().width / 2;
        int y = dim.height / 2 - this.frame.getSize().height / 2;
        this.frame.setLocation(x, y);
        this.fileProgressBar = new JProgressBar(0, 10);
        this.fileProgressBar.setValue(0);
        this.fileProgressBar.setStringPainted(true);
        this.fullProgressBar = new JProgressBar(0, 10);
        this.fullProgressBar.setValue(0);
        this.fullProgressBar.setStringPainted(true);
        this.currentDownload = new JLabel(" ");
        this.downloadSpeedLabel = new JLabel(" ");
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        this.panel.add(this.currentDownload);
        this.panel.add(this.fileProgressBar);
        this.panel.add(this.fullProgressBar);
        this.panel.add(this.downloadSpeedLabel);
        this.frame.setContentPane(this.panel);
        this.fullProgressBar.setMaximum(this.getTotalDownloadSize());
        this.frame.setVisible(true);
        System.out.println(this.fullProgressBar.getMaximum());
        if (this.fileChecker.remoteList.isEmpty()) {
            this.frame.dispose();
            JOptionPane.showMessageDialog(null, Localization.LANG.getTranslation("err.networkerror"), Localization.LANG.getTranslation("misc.error"), 0);
            return;
        }
        this.deleteDeprecated();
        this.downloadFiles();
    }

    private int getTotalDownloadSize() {
        int size = 0;
        for (FileEntry entry : this.fileChecker.missingList) {
            size = (int)((long)size + entry.getSize());
        }
        return size;
    }

    public void deleteDeprecated() {
        for (FileEntry entry : this.fileChecker.outdatedList) {
            File f = new File(this.modPackDir, entry.getPath());
            if (f.delete()) {
                System.out.println(String.format(Localization.LANG.getTranslation("file.removed.md5.success"), f.getPath(), entry.getMd5()));
                continue;
            }
            this.frame.dispose();
            JOptionPane.showMessageDialog(null, Localization.LANG.getTranslation("err.cannotdeletefile") + " : " + f.getPath(), "Error", 0);
        }
    }

    public void downloadFiles() {
        new Thread(){

            @Override
            public void run() {
                ProcessInstall.this.downloadMod(this);
                if (ProcessInstall.this.runner.shouldDownloadLib()) {
                    ProcessInstall.this.downloadLib(this);
                }
                ProcessInstall.this.finish();
            }
        }.start();
    }

    public void downloadMod(Thread thread) {
        for (FileEntry entry : this.fileChecker.missingList) {
            File f = new File(this.modPackDir, entry.getPath());
            if (f.getParentFile() != null && !f.getParentFile().isDirectory()) {
                f.getParentFile().mkdirs();
            }
            this.currentDownload.setText(entry.getPath());
            System.out.println(String.format(Localization.LANG.getTranslation("proc.downloadingfile"), entry.getUrl().toString(), f.getPath(), entry.getMd5()));
            if (DownloadUtils.downloadFile(entry.getUrl(), f, this.fileProgressBar, this.fullProgressBar, this.downloadSpeedLabel)) continue;
            this.frame.dispose();
            thread.interrupt();
            JOptionPane.showMessageDialog(null, Localization.LANG.getTranslation("err.cannotdownload") + " : " + entry.getUrl().toString(), Localization.LANG.getTranslation("misc.error"), 0);
        }
    }

    public void downloadLib(Thread thread) {
        this.frame.setTitle(Localization.LANG.getTranslation("title.libs"));
        this.fullProgressBar.setValue(0);
        File librariesDir = new File(this.mcDir, "libraries");
        List<JsonNode> libraries = RemoteInfoReader.instance().getProfileInfo().getArrayNode("libraries");
        ArrayList<LibEntry> libEntryList = new ArrayList<LibEntry>();
        int max = 0;
        for (JsonNode library : libraries) {
            ArrayList<String> checksums = null;
            String libName = library.getStringValue("name");
            if (!library.isBooleanValue("required") || !library.getBooleanValue("required").booleanValue()) continue;
            if (library.isArrayNode("checksums")) {
                checksums = Lists.newArrayList(Lists.transform(library.getArrayNode("checksums"), new Function<JsonNode, String>(){

                    @Override
                    public String apply(JsonNode node) {
                        return node.getText();
                    }
                }));
            }
            System.out.println(String.format(Localization.LANG.getTranslation("proc.consideringlib"), libName));
            String[] nameparts = Iterables.toArray(Splitter.on(':').split(libName), String.class);
            nameparts[0] = nameparts[0].replace('.', '/');
            String jarName = nameparts[1] + '-' + nameparts[2] + ".jar";
            String pathName = nameparts[0] + '/' + nameparts[1] + '/' + nameparts[2] + '/' + jarName;
            File libPath = new File(librariesDir, pathName.replace('/', File.separatorChar));
            String libURL = "https://libraries.minecraft.net/";
            if (library.isStringValue("url")) {
                libURL = library.getStringValue("url") + "/";
            }
            if (libPath.exists() && DownloadUtils.checksumValid(libPath, checksums)) continue;
            libPath.getParentFile().mkdirs();
            libURL = libURL + pathName;
            File pack = null;
            boolean xz = false;
            if (library.isBooleanValue("xz") && library.getBooleanValue("xz").booleanValue()) {
                xz = true;
                pack = new File(libPath.getParentFile(), libPath.getName() + ".pack.xz");
                libURL = libURL + ".pack.xz";
            }
            if (library.isStringValue("directURL")) {
                libURL = library.getStringValue("directURL");
            }
            try {
                URL url = new URL(libURL);
                URLConnection connection = url.openConnection();
                int fileLength = connection.getContentLength();
                max += fileLength;
                libEntryList.add(new LibEntry(libURL, libName, libPath, pack, fileLength, xz));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.fullProgressBar.setMaximum(max);
        for (LibEntry entry : libEntryList) {
            this.currentDownload.setText(String.format(Localization.LANG.getTranslation("proc.downloadinglib"), entry.getName()));
            try {
                if (entry.isXZ()) {
                    if (!DownloadUtils.downloadFile(new URL(entry.getUrl()), entry.getPackDest(), this.fileProgressBar, this.fullProgressBar, this.downloadSpeedLabel)) {
                        thread.interrupt();
                        this.frame.dispose();
                        JOptionPane.showMessageDialog(null, Localization.LANG.getTranslation("err.cannotdownload") + " : " + entry.getUrl().toString() + ".pack.xz", Localization.LANG.getTranslation("misc.error"), 0);
                        continue;
                    }
                    try {
                        this.currentDownload.setText(Localization.LANG.getTranslation("proc.unpackingfile") + " : " + entry.getPackDest().toString());
                        DownloadUtils.unpackLibrary(entry.getDest(), Files.toByteArray(entry.getPackDest()));
                        this.currentDownload.setText(String.format(Localization.LANG.getTranslation("file.unpacked.success"), entry.getPackDest().toString()));
                        entry.getPackDest().delete();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (DownloadUtils.downloadFile(new URL(entry.getUrl()), entry.getDest(), this.fileProgressBar, this.fullProgressBar, this.downloadSpeedLabel)) continue;
                thread.interrupt();
                this.frame.dispose();
                JOptionPane.showMessageDialog(null, Localization.LANG.getTranslation("err.cannotdownload") + " : " + entry.getUrl().toString() + ".pack.xz", "Error", 0);
            }
            catch (HeadlessException e) {
                e.printStackTrace();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
    }

    public void finish() {
        this.frame.setTitle(Localization.LANG.getTranslation("misc.finishing"));
        this.createOrUpdateProfile();
        this.writeModPackInfo();
        if (!this.update) {
            this.addToProfileList();
        }
        this.frame.dispose();
        this.runner.onFinish();
    }

    private void createOrUpdateProfile() {
        String mcVersion = RemoteInfoReader.instance().getMinecraftVersion();
        File versionRootDir = new File(this.mcDir, "versions");
        String modpackName = RemoteInfoReader.instance().getModPackName();
        File modpackVersionDir = new File(versionRootDir, modpackName);
        if (!modpackVersionDir.exists()) {
            modpackVersionDir.mkdirs();
        }
        File modpackJar = new File(modpackVersionDir, modpackName + ".jar");
        File modpackJson = new File(modpackVersionDir, modpackName + ".json");
        File minecraftJar = new File(new File(versionRootDir, mcVersion), mcVersion + ".jar");
        if (minecraftJar.exists()) {
            try {
                Files.copy(minecraftJar, modpackJar);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                DownloadUtils.downloadFile(new URL("https://s3.amazonaws.com/Minecraft.Download/versions/" + mcVersion + "/" + mcVersion + ".jar"), modpackJar, this.fileProgressBar, this.fullProgressBar, this.downloadSpeedLabel);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        JsonRootNode versionJson = JsonNodeFactories.object(RemoteInfoReader.instance().getProfileInfo().getFields());
        try {
            BufferedWriter newWriter = Files.newWriter(modpackJson, Charsets.UTF_8);
            JSON_FORMATTER.format(versionJson, newWriter);
            newWriter.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, Localization.LANG.getTranslation("err.cannotwriteversion"), Localization.LANG.getTranslation("misc.error"), 0);
        }
    }

    public void addToProfileList() {
        JsonRootNode jsonProfileData;
        String modpackName = RemoteInfoReader.instance().getModPackName();
        File launcherProfiles = new File(this.mcDir, "launcher_profiles.json");
        if (!launcherProfiles.exists()) {
            JOptionPane.showMessageDialog(null, Localization.LANG.getTranslation("err.mcprofilemissing"), Localization.LANG.getTranslation("misc.error"), 0);
            this.frame.dispose();
        }
        JdomParser parser = new JdomParser();
        try {
            jsonProfileData = parser.parse(Files.newReader(launcherProfiles, Charsets.UTF_8));
        }
        catch (InvalidSyntaxException e) {
            JOptionPane.showMessageDialog(null, Localization.LANG.getTranslation("err.mcprofilecorrupted"), Localization.LANG.getTranslation("misc.error"), 0);
            throw Throwables.propagate(e);
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
        JsonField[] fields = null;
        fields = RemoteInfoReader.instance().hasArgument() ? new JsonField[]{JsonNodeFactories.field("name", JsonNodeFactories.string(modpackName)), JsonNodeFactories.field("lastVersionId", JsonNodeFactories.string(modpackName)), JsonNodeFactories.field("javaArgs", JsonNodeFactories.string(RemoteInfoReader.instance().getArgument()))} : new JsonField[]{JsonNodeFactories.field("name", JsonNodeFactories.string(modpackName)), JsonNodeFactories.field("lastVersionId", JsonNodeFactories.string(modpackName))};
        HashMap<JsonStringNode, JsonNode> profileCopy = Maps.newHashMap(jsonProfileData.getNode("profiles").getFields());
        HashMap<JsonStringNode, JsonNode> rootCopy = Maps.newHashMap(jsonProfileData.getFields());
        profileCopy.put(JsonNodeFactories.string(modpackName), JsonNodeFactories.object(fields));
        JsonRootNode profileJsonCopy = JsonNodeFactories.object(profileCopy);
        rootCopy.put(JsonNodeFactories.string("profiles"), profileJsonCopy);
        jsonProfileData = JsonNodeFactories.object(rootCopy);
        try {
            BufferedWriter newWriter = Files.newWriter(launcherProfiles, Charsets.UTF_8);
            JSON_FORMATTER.format(jsonProfileData, newWriter);
            newWriter.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, Localization.LANG.getTranslation("err.cannotwriteprofile"), Localization.LANG.getTranslation("misc.error"), 0);
        }
    }

    public void writeModPackInfo() {
        File info = new File(this.modPackDir, RemoteInfoReader.instance().getModPackName() + ".json");
        if (!info.exists()) {
            try {
                info.createNewFile();
            }
            catch (IOException e) {
                throw Throwables.propagate(e);
            }
        }
        JsonRootNode json = JsonNodeFactories.object(JsonNodeFactories.field("mc", JsonNodeFactories.string(RemoteInfoReader.instance().getMinecraftVersion())), JsonNodeFactories.field("forge", JsonNodeFactories.string(RemoteInfoReader.instance().getForgeVersion())), JsonNodeFactories.field("remote", JsonNodeFactories.string(RemoteInfoReader.instance().remoteUrl)));
        try {
            BufferedWriter writer = Files.newWriter(info, Charsets.UTF_8);
            JSON_FORMATTER.format(json, writer);
            writer.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, Localization.LANG.getTranslation("err.cannotwriteversion"), Localization.LANG.getTranslation("misc.error"), 0);
        }
    }
}

