/*
 * Decompiled with CFR 0.152.
 */
package fr.minecraftforgefrance.common;

import fr.minecraftforgefrance.common.DownloadMod;
import fr.minecraftforgefrance.common.EnumOS;
import fr.minecraftforgefrance.common.FileEntry;
import fr.minecraftforgefrance.common.Localization;
import fr.minecraftforgefrance.common.RemoteInfoReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JOptionPane;

public class FileChecker {
    public List<FileEntry> remoteList = Collections.synchronizedList(new ArrayList());
    public List<FileEntry> syncList = new ArrayList<FileEntry>();
    public List<String> checkDir = new ArrayList<String>();
    public List<FileEntry> localList = new ArrayList<FileEntry>();
    public List<FileEntry> missingList;
    public List<FileEntry> outdatedList;
    private File mcDir = EnumOS.getMinecraftDefaultDir();
    private File modPackDir = new File(new File(this.mcDir, "modpacks"), RemoteInfoReader.instance().getModPackName());

    public FileChecker() {
        DownloadMod.instance().getRemoteList(this.remoteList, this.checkDir);
        this.getLocalFile();
        this.compare();
    }

    private void getLocalFile() {
        if (!this.mcDir.exists() || !this.mcDir.isDirectory()) {
            JOptionPane.showMessageDialog(null, Localization.LANG.getTranslation("err.mcdirmissing"), Localization.LANG.getTranslation("misc.error"), 0);
            return;
        }
        if (!this.modPackDir.exists()) {
            this.modPackDir.mkdirs();
            return;
        }
        if (!this.modPackDir.isDirectory()) {
            this.modPackDir.delete();
            this.modPackDir.mkdirs();
        }
        for (String dirName : this.checkDir) {
            File dir = new File(this.modPackDir, dirName);
            if (!dir.exists() || !dir.isDirectory()) continue;
            if (RemoteInfoReader.instance().getSyncDir().contains(dirName)) {
                this.recursifAdd(this.localList, this.syncList, dir, this.modPackDir.getAbsolutePath(), true);
                continue;
            }
            this.recursifAdd(this.localList, this.syncList, dir, this.modPackDir.getAbsolutePath(), false);
        }
    }

    private void compare() {
        this.missingList = new ArrayList<FileEntry>(this.remoteList);
        this.missingList.removeAll(this.localList);
        this.outdatedList = new ArrayList<FileEntry>(this.syncList);
        this.outdatedList.removeAll(this.remoteList);
        if (RemoteInfoReader.instance().hasWhiteList()) {
            block0: for (String md5 : RemoteInfoReader.instance().getWhileList()) {
                for (FileEntry file : this.outdatedList) {
                    if (!file.getMd5().equals(md5)) continue;
                    this.outdatedList.remove(file);
                    continue block0;
                }
            }
        }
    }

    private void recursifAdd(List<FileEntry> list, List<FileEntry> syncList, File dir, String modpackPath, boolean syncDir) {
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                this.recursifAdd(list, syncList, file, modpackPath, syncDir);
                continue;
            }
            if (syncDir) {
                syncList.add(new FileEntry(this.getMd5(file), file.getAbsolutePath().replace(modpackPath + File.separator, ""), file.length()));
            }
            list.add(new FileEntry(this.getMd5(file), file.getAbsolutePath().replace(modpackPath + File.separator, ""), file.length()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMd5(File file) {
        FilterInputStream stream = null;
        try {
            stream = new DigestInputStream(new FileInputStream(file), MessageDigest.getInstance("MD5"));
            byte[] buffer = new byte[65536];
            int read = stream.read(buffer);
            while (read >= 1) {
                read = stream.read(buffer);
            }
        }
        catch (Exception ignored) {
            String string = null;
            return string;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException localIOException) {}
            }
        }
        return String.format("%1$032x", new BigInteger(1, ((DigestInputStream)stream).getMessageDigest().digest()));
    }
}

