/*
 * Decompiled with CFR 0.152.
 */
package argo.jdom;

import argo.jdom.JsonArray;
import argo.jdom.JsonField;
import argo.jdom.JsonNode;
import argo.jdom.JsonObject;
import argo.jdom.JsonRootNode;
import argo.jdom.JsonStringNode;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public final class JsonNodeFactories {
    public static JsonStringNode string(String value) {
        return new JsonStringNode(value);
    }

    public static JsonRootNode array(Iterable<JsonNode> elements) {
        return new JsonArray(elements);
    }

    public static JsonRootNode array(JsonNode ... elements) {
        return JsonNodeFactories.array(Arrays.asList(elements));
    }

    public static JsonRootNode object(Map<JsonStringNode, JsonNode> fields) {
        return new JsonObject(fields);
    }

    public static JsonRootNode object(JsonField ... fields) {
        return JsonNodeFactories.object(Arrays.asList(fields));
    }

    public static JsonRootNode object(final Iterable<JsonField> fields) {
        return JsonNodeFactories.object((Map<JsonStringNode, JsonNode>)new HashMap<JsonStringNode, JsonNode>(){
            {
                for (JsonField field : fields) {
                    this.put(field.getName(), field.getValue());
                }
            }
        });
    }

    public static JsonField field(String name, JsonNode value) {
        return new JsonField(JsonNodeFactories.string(name), value);
    }
}

