/*
 * Decompiled with CFR 0.152.
 */
package fr.minecraftforgefrance.installer;

import com.google.common.base.Throwables;
import fr.minecraftforgefrance.common.FileChecker;
import fr.minecraftforgefrance.common.IInstallRunner;
import fr.minecraftforgefrance.common.Localization;
import fr.minecraftforgefrance.common.ProcessInstall;
import fr.minecraftforgefrance.common.RemoteInfoReader;
import fr.minecraftforgefrance.installer.CreditFrame;
import fr.minecraftforgefrance.plusplus.PlusPlusGame;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class InstallerFrame
extends JFrame
implements IInstallRunner {
    private static final long serialVersionUID = 1L;

    public InstallerFrame() {
        BufferedImage image;
        this.setTitle(String.format(Localization.LANG.getTranslation("title.installer"), RemoteInfoReader.instance().getModPackName()));
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        try {
            image = ImageIO.read(this.getClass().getResourceAsStream("/installer/logo.png"));
        }
        catch (IOException e) {
            throw Throwables.propagate(e);
        }
        final Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        ImageIcon icon = new ImageIcon(image);
        JLabel logoLabel = new JLabel(icon);
        logoLabel.setAlignmentX(0.5f);
        logoLabel.setAlignmentY(0.5f);
        if (image.getWidth() > dim.width || image.getHeight() + 10 > dim.height) {
            JOptionPane.showMessageDialog(null, Localization.LANG.getTranslation("err.bigimage"), Localization.LANG.getTranslation("misc.error"), 0);
            this.dispose();
        } else {
            logoLabel.setSize(image.getWidth(), image.getHeight());
            panel.add(logoLabel);
        }
        JButton install = new JButton(Localization.LANG.getTranslation("scr.btn.install"));
        install.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InstallerFrame.this.dispose();
                FileChecker checker = new FileChecker();
                new ProcessInstall(checker, InstallerFrame.this, false);
            }
        });
        JButton credit = new JButton(Localization.LANG.getTranslation("scr.btn.credits"));
        credit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreditFrame credit = new CreditFrame(dim);
                credit.setVisible(true);
            }
        });
        JButton cancel = new JButton(Localization.LANG.getTranslation("misc.cancel"));
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InstallerFrame.this.dispose();
            }
        });
        JPanel buttonpanel = new JPanel();
        buttonpanel.add(install);
        buttonpanel.add(credit);
        buttonpanel.add(cancel);
        JLabel welcome = new JLabel(RemoteInfoReader.instance().getWelcome());
        welcome.setAlignmentX(0.5f);
        welcome.setAlignmentY(0.5f);
        JLabel mc = new JLabel("Minecraft : " + RemoteInfoReader.instance().getMinecraftVersion());
        mc.setAlignmentX(0.5f);
        mc.setAlignmentY(0.5f);
        JLabel forge = new JLabel("Forge : " + RemoteInfoReader.instance().getForgeVersion());
        forge.setAlignmentX(0.5f);
        forge.setAlignmentY(0.5f);
        panel.add(welcome);
        panel.add(mc);
        panel.add(forge);
        panel.add(buttonpanel);
        this.add(panel);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                InstallerFrame.this.requestFocus();
            }
        });
        this.pack();
        int x = dim.width / 2 - this.getSize().width / 2;
        int y = dim.height / 2 - this.getSize().height / 2;
        this.setLocation(x, y);
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '+' && !PlusPlusGame.isRunning) {
                    new PlusPlusGame();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
    }

    public void run() {
        this.setVisible(true);
    }

    @Override
    public void onFinish() {
        JOptionPane.showMessageDialog(null, Localization.LANG.getTranslation("installation.success"), Localization.LANG.getTranslation("misc.success"), 1);
    }

    @Override
    public boolean shouldDownloadLib() {
        return true;
    }
}

